uniform sampler2D s_tex0; 

uniform float exposure;

uniform vec4 u_blendcolor;

varying vec2 v_texcoord;

const float MIDDLE_GREY = 0.72;
const float FUDGE = 0.001;
const float L_WHITE = 1.5;

// from: http://www.koders.com/noncode/fidB134383CDA66ACFDDE1E2BB70579CB362DC28D24.aspx
/** Tone mapping function 
@note Only affects rgb, not a
@param inColour The HDR colour
@param lum The scene lumninence 
@returns Tone mapped colour
*/
vec4 toneMap(in vec4 inColour, in float lum)
{
	// From Reinhard et al
	// "Photographic Tone Reproduction for Digital Images"
	
	// Initial luminence scaling (equation 2)
    inColour.rgb *= MIDDLE_GREY / (FUDGE + lum);

	// Control white out (equation 4 nom)
    inColour.rgb *= (1.0 + inColour.rgb / L_WHITE);

	// Final mapping (equation 4 denom)
	inColour.rgb /= (1.0 + inColour.rgb);
	
	return inColour;

}

void main()
{	
	// vec4 color = texture2D(s_tex0, v_texcoord) * u_blendcolor;

	// // balance is based on the eye
	// float Y = dot(vec4(0.30, 0.59, 0.11, 1.0), color);
	// vec4 ldrColor = (1.0 - exp2 (-color * exposure)) * Y;
	// ldrColor.a = 1.0;

	// Sampling The Texture And Passing It To The Frame Buffer
	gl_FragColor = toneMap(texture2D(s_tex0, v_texcoord) * u_blendcolor, exposure);
} 
